define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/preferred-date/switch-to-request-popup',
], function(Backbone, Layout, SwitchToRequestPopupView) {
    'use strict';

    describe('Switch to Request Modal', function() {
        var view;
        var message;
        var $view;
        var layout;
        var content;

        beforeEach(function() {
            layout = new Layout();
            layout.render();
            content = layout.getRegion('content');
            $(content.el).append('<a class="test-link">A Link</a>');
            message = new Backbone.Model({
                messageId: 'appointmentNoPreferredDatePopup',
                messageText: 'this is a custom message',
            });

            view = new SwitchToRequestPopupView({
                elAfterClose: layout.$el.find('.test-link'),
                customMessage: message.get('messageText'),
            });

            view.openPopup();
            $view = view.$el;
        });

        afterEach(function() {
            view.closePopup();
        });

        it("shows `Don't see a date or time that works for you?` in the header", function() {
            expect($view.find('.ui-title').text()).toEqual('Don\'t see a date or time that works for you?');
        });

        it('shows the correct body text', function() {
            expect($view.find('.ui-content').find('p')
                .text()).toEqual(message.get('messageText'));
        });

        it('has a OK button', function() {
            expect($view.find('#switch-to-request-return-btn.return-btn').text()).toEqual('OK');
        });
    });
}
);
